// Rad_Slider.js | Radnen 2008 //
// Creates a slider object that can be used
// in options menus.

function Slider(x, y, w, ticks, style)
{
	if (!this instanceof Slider)
	return new Slider(x, y, style);
	
	this.x = x;
	this.y = y;
	this.w = w;
	this.style = style || new Style();
	this.pos = 0;
	this.ticks = ticks;
	this.color = Colors.white;
	this.dist = this.w/this.ticks;
	this.onSlideLeft = function(){};
	this.onSlideRight = function(){};
	this.preRender = function(){};
}

Slider.prototype.blit = function()
{
	this.preRender();
	Rectangle(this.x, this.y, this.w, 3, Colors.black);
	Line(this.x+1, this.y+1, this.x+this.w-2, this.y+1, this.color)
	this.style.downArrow.blit(this.x - this.style.downArrow.width/2 + this.pos * this.dist, this.y - this.style.downArrow.height);
}

Slider.prototype.increment = function(num)
{
	if (!num) num = 1;
	if (this.pos < this.ticks)
	{
		this.pos+=num;
		if (this.pos > this.ticks) this.pos = this.ticks;
		this.onSlideRight();
	}
}

Slider.prototype.decrement = function(num)
{
	if (!num) num = 1;
	if (this.pos > 0)
	{
		this.pos-=num;
		if (this.pos < 0) this.pos = 0;
		this.onSlideLeft();
	}
}